import { View, StyleSheet } from "react-native";
import React from "react";
import SkeletonElement from "../../SkeletonElement";
import dpr from "../../../../screens/Utilities/CustomStyleAttribute/dpr";

const ProfileSkeleton = () => {
    return (
        <View style={styles.flexProperties}>
            <SkeletonElement wrapperStyle={styles.skeltonWrapperStyle}/>
            <View style={styles.skeletonElementContainer}>
                <SkeletonElement wrapperStyle={styles.skeletonWrapper(20, 200)}/>
                <SkeletonElement wrapperStyle={styles.skeletonWrapper(12, 250)} />
                <SkeletonElement wrapperStyle={styles.skeletonWrapper(12, 250)} />
            </View>
        </View>
    );
};

export default ProfileSkeleton;

const styles = StyleSheet.create({
    flexProperties: {
        flexDirection: "row",
        alignItems: "center",
    },
    skeltonWrapperStyle: {
        height: dpr(100),
        width: dpr(100),
        borderRadius: 50,
    },
    skeletonWrapper: (height, minusWidth) => ({
        height: dpr(height),
        width: dpr("wf") - dpr(minusWidth),
    }),
    skeletonElementContainer: {
        marginLeft: dpr(10)
    },
});
